
:- dynamic(neg / 1).
:- set_stream(warning_output, null).
:- ensure_loaded(['literalsUpdate.pl']).
:- ensure_loaded(['heuristicPlanner.pl']).
:- ensure_loaded(['planningGraphHeuristicRevised.pl']).

:- discontiguous(available/2).
:- discontiguous(value/3).

fluents( [value(_,_,_), available(_,_) ] ).
actions( [add(C1,V1, C2,V2), mult(C1,V1,C2,V2) ]). 
fluent(available(_)).   
fluent(value(_,_)). 

%%% Poss Predicates %%%

%preconditions requires a conjunctive query with disequality (\not=)

poss(add(C1,V1, C2,V2),[neg(C1 = C2)],S) :- 
    instantiate([ available(C1), available(C2), (C1 \== C2), value(C1,V1), value(C2,V2)], S).

poss(mult(C1,V1,C2,V2),[neg(C1=C2)], S) :- 
    instantiate([ available(C1), available(C2), (C1 \== C2), value(C1,V1), value(C2,V2)], S).

%%% Action Preconditions %%%

actionPrec(add(C1,V1,C2,V2), [available(C1),available(C2),value(C1,V1),value(C2,V2)] ).

actionPrec(mult(C1,V1,C2,V2),[available(C1),available(C2),value(C1,V1),value(C2,V2)] ).


%%% Positive Effects %%%

posEffect( add(C1,V1,C2,V2), State, value(C1,V) ) :- V is V1 + V2.

posEffect( mult(C1,V1,C2,V2), State, value(C1,V) ) :- V is V1 * V2.


%%% Negative Effects %%%

negEffect(add(C1,V1,C2,V2), State, value(C1,V1) ).
negEffect(add(C1,V1,C2,V2), State, value(C2,V2) ).
negEffect(add(C1,V1,C2,V2), State, available(C2) ).

negEffect(mult(C1,V1,C2,V2), State, value(C1,V1) ).
negEffect(mult(C1,V1,C2,V2), State, value(C2,V2) ).
negEffect(mult(C1,V1,C2,V2), State, available(C2) ).


